' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

''' <summary>
''' Klasa Helpers zawiera kilka metod wspdzielonych, uywanych przez witryn.
''' </summary>
Public Class Helpers

#Region "Konstruktor(y)"

  Private Sub New()
    ' Ukryj konstruktor, poniewa ta klasa ma wycznie skadniki o dostpie wspdzielonym.
  End Sub

#End Region

#Region "Metody publiczne"

#Region "Metody dla aplikacji"

  ''' <summary>
  ''' Ustala, czy zostaa okrelona aktywna aplikacja i przekierowuje, jeli nie.
  ''' </summary>
  ''' <param name="originalPage">Nazwa strony ktra wywoaa t metod. SwitchApplication.aspx przekieruje czonka zespou na t stron po wybraniu przez niego aplikacji.</param>
  Public Shared Function CheckApplicationState(ByVal originalPage As String) As Boolean
    If HttpContext.Current.Session("ApplicationId") Is Nothing Or HttpContext.Current.Session("MemberId") Is Nothing Then
      HttpContext.Current.Server.Transfer("~/Bugs/SwitchApplication.aspx?ShowLabel=True&OriginalPage=" & originalPage)
    End If
    Return True
  End Function

  ''' <summary>
  ''' Zapamituje biec aktywn aplikacj w stanie sesji.
  ''' </summary>
  ''' <param name="applicationId">Identyfikator aktywnej aplikacji.</param>
  ''' <param name="applicationDescription">Nazwa aktywnej applikacji.</param>
  Public Shared Sub SetApplication(ByVal applicationId As Integer, ByVal applicationDescription As String)
    If Not applicationDescription = String.Empty Then
      HttpContext.Current.Session("ApplicationId") = applicationId
      HttpContext.Current.Session("ApplicationDescription") = applicationDescription
    Else
      Throw New ArgumentException("Nie mona ustawi aplikacji dla sesji z pust waciwoci ApplicationDescription.")
    End If
  End Sub

  ''' <summary>
  ''' Zwraca identyfikator biecej aktywnej aplikacji.
  ''' </summary>
  Public Shared Function GetApplicationId() As Integer
    If HttpContext.Current.Session("ApplicationId") IsNot Nothing Then
      Return Convert.ToInt32(HttpContext.Current.Session("ApplicationId"))
    Else
      Throw New ArgumentException("Nie mona pobra identyfikatora aplikacji z sesji.")
    End If
  End Function

#End Region

#Region "Metody dla identyfikatorw skadnikw"

  ''' <summary>
  ''' Zwraca warto ProviderUserKey dla biecego skadnika i zapamituje j w stanie sesji.
  ''' </summary>
  Public Shared Sub SetMemberId()
    If HttpContext.Current.User.Identity.IsAuthenticated Then
      If HttpContext.Current.Session("MemberId") Is Nothing Then
        Dim myUser As MembershipUser = Membership.GetUser(HttpContext.Current.User.Identity.Name)
        HttpContext.Current.Session("MemberId") = myUser.ProviderUserKey
      End If
    Else
      HttpContext.Current.Response.Redirect("~/Login.aspx")
    End If
  End Sub

  ''' <summary>
  ''' Usuwa MemberId ze stanu sesji.
  ''' </summary>
  Public Shared Sub ClearMemberId()
    HttpContext.Current.Session("MemberId") = Nothing
  End Sub

  ''' <summary>
  ''' Zwraca MemberId zawarty w stanie sesji.
  ''' </summary>
  ''' <returns></returns>
  Public Shared Function GetMemberId() As Guid
    If HttpContext.Current.Session("MemberId") IsNot Nothing Then
      Return New Guid(HttpContext.Current.Session("MemberId").ToString())
    Else
      Return Guid.Empty
    End If
  End Function

#End Region

  ''' <summary>
  ''' Ta metoda formatuje PagerBar przesanej kontrolki GridView. Dodaje sowo Page, pogrubia odnonik i dodaje etykietk tekstow (tooltip).
  ''' </summary>
  ''' <param name="thePagerBar">Kontrolka GridViewRow, ktra ma zosta sformatowana.</param>
  ''' <remarks>Upewnij si, by wywoa t metod dla GridView.TopPagerRow oraz GridView.BottomPagerRow</remarks>
  Public Shared Sub FormatGridViewPagerBar(ByVal thePagerBar As GridViewRow)
    ' Przejdmy iteracyjnie po wszystkich znacznikach <td> w tym wierszu.
    ' Kontrolka GridViewRow przesana do tej metody jest ca formatk PagerRow (TableRow)
    ' Ten wiersz tabeli zawiera z kolei komrk Html 
    ' Ta komrka z kolei zawiera tabel Html, w ktrej s wiersze tabeli Html z wieloma komrkami Html
    ' Kada z tych komrek zawiera kontrolk Label lub LinkButton
    ' Tak wic uywajc wyraenia thePagerBar.Controls(0).Controls(0).Controls(0) dostajemy si do wiersza wewntrznej tabeli
    ' a potem przechodzimy po jego kolekcji Cells 
    Dim innerPagerRow As TableRow = CType(thePagerBar.Controls(0).Controls(0).Controls(0), TableRow)
    For Each pagerCell As TableCell In innerPagerRow.Cells()
      If pagerCell.Controls.Count > 0 Then
        ' Znaleziono co najmniej 1 kontrolk potomn
        If TypeOf (pagerCell.Controls(0)) Is Label Then
          ' Znalelimy znacznik <span> z biec stron. Zastosujmy pogrubienie czcionki
          Dim pagerLabel As Label = CType(pagerCell.Controls(0), Label)
          pagerLabel.Font.Bold = True
        End If
        If TypeOf (pagerCell.Controls(0)) Is LinkButton Then
          ' Znalelismy odnonik <a> prowadzcy do poprzedniej lub nastpnej strony. Zmieniamy mu waciwoci ToolTip i Text
          Dim pagerLink As LinkButton = CType(pagerCell.Controls(0), LinkButton)
          pagerLink.ToolTip = "Id do strony " & pagerLink.Text
          pagerLink.Text = "(" + pagerLink.Text + ")"
        End If
      End If
    Next
    ' Na koniec dodajemy na pocztku komrki sowo Strona
    Dim myLiteralControl As LiteralControl = New LiteralControl("<strong>Strona: </strong>")
    innerPagerRow.Cells(0).Controls.AddAt(0, myLiteralControl)
  End Sub

#End Region

End Class
